<?php
header('Content-Type: application/json; charset=utf-8');
require_once __DIR__.'/../config/db.php';

$label = trim($_POST['label'] ?? '');
$confidence = (float)($_POST['confidence'] ?? 0);
$url = trim($_POST['url'] ?? '');
$ua = $_SERVER['HTTP_USER_AGENT'] ?? '';
$ip = $_SERVER['REMOTE_ADDR'] ?? '';

function parseLabel($label){
  $p = explode('_', $label);
  if (!$p || count($p)<2) return [null,null,null];
  if ($p[0]==='billete') return ['billete', (int)$p[1], $p[2] ?? null];
  if ($p[0]==='moneda')  return ['moneda', (int)$p[1], null];
  return [null,null,null];
}
[$type,$value,$side] = parseLabel($label);

$stmt = $pdo->prepare("INSERT INTO scans(ts,label,confidence,type,value,side,url,user_agent,ip) VALUES (NOW(),?,?,?,?,?,?,?,?)");
$stmt->execute([$label,$confidence,$type,$value,$side,$url,$ua,$ip]);

echo json_encode(['ok'=>true]);
