
CREATE TABLE IF NOT EXISTS denominations (
  id INT AUTO_INCREMENT PRIMARY KEY,
  type ENUM('billete','moneda') NOT NULL,
  value INT NOT NULL,
  family VARCHAR(50) DEFAULT '',
  obverse_desc VARCHAR(150) DEFAULT '',
  reverse_desc VARCHAR(150) DEFAULT '',
  ref_url VARCHAR(255) NOT NULL
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4;

CREATE UNIQUE INDEX ux_type_value ON denominations(type, value);

INSERT INTO denominations (type, value, family, obverse_desc, reverse_desc, ref_url) VALUES
('billete', 10,   '1970-10-12', '10 Pesos Oro 1970 (reposición, R pequeña abajo)', '', 'https://guia.numismaticol.com/b650-10-pesos-oro-1970-octubre-12-reposicion-r-pequena-abajo-en-el-centromuy-escaso/'),
('billete', 2,    '1923-07-20', '2 Pesos Oro 1923', '', 'https://guia.numismaticol.com/b758-2-pesos-oro-1923-julio-20/'),
('billete', 2000, '2004-02-18', '2000 Pesos 2004', '', 'https://guia.numismaticol.com/b335-2000-pesos-2004-febrero-18-19/');
