
import { MockDetector } from './detector_mock.js';

const video = document.getElementById('video');
const btnStart = document.getElementById('btn-start');
const btnScan  = document.getElementById('btn-scan');
const btnOpen  = document.getElementById('btn-open');
const statusBadge = document.getElementById('status-badge');
const outLabel = document.getElementById('out-label');
const outConf  = document.getElementById('out-conf');
const outParsed= document.getElementById('out-parsed');
const outUrl   = document.getElementById('out-url');

const selType  = document.getElementById('sel-type');
const selValue = document.getElementById('sel-value');
const btnManual= document.getElementById('btn-manual');
const btnOpenManual = document.getElementById('btn-open-manual');

let stream=null;
let detector=null;
let last=null;

function setStatus(t){ statusBadge.textContent=t; }
function parseLabel(label){
  const p = label.split('_');
  if (p[0]==='billete') return `billete ${p[1]} (${p[2]||'—'})`;
  if (p[0]==='moneda')  return `moneda ${p[1]}`;
  return null;
}
function setResult(res){
  if(!res){
    outLabel.textContent='—'; outConf.textContent='—'; outParsed.textContent='—'; outUrl.textContent='—';
    btnOpen.disabled=true; last=null; return;
  }
  outLabel.textContent=res.label;
  outConf.textContent=(res.confidence*100).toFixed(1)+'%';
  outParsed.textContent=parseLabel(res.label) || '—';
  outUrl.textContent='resolviendo…';
  btnOpen.disabled=true;
  last=res;
  resolveGuide({label:res.label}).then(url=>{
    if(url){
      outUrl.innerHTML=`<a href="${url}" target="_blank" rel="noopener">${url}</a>`;
      btnOpen.disabled=false;
      btnOpen.onclick=()=>window.open(url,'_blank');
  } else {
      outUrl.textContent='No encontrada';
    }
  });
}

async function startCamera(){
  try{
    stream = await navigator.mediaDevices.getUserMedia({video:{facingMode:'environment'}, audio:false});
    video.srcObject = stream;
    setStatus('Cámara encendida');
  }catch(e){ setStatus('Error cámara: '+e.message); }
}

async function ensureDetector(){
  detector = new MockDetector();
  await detector.init();
  setStatus('Detector simulado listo');
}

async function resolveGuide(payload){
  const fd = new FormData();
  Object.entries(payload).forEach(([k,v])=>fd.append(k, v));
  const r = await fetch(`${API_BASE}/resolve.php`, {method:'POST', body: fd});
  const j = await r.json();
  return j?.url || null;
}

btnStart.onclick = async ()=>{
  await startCamera();
  await ensureDetector();
};

btnScan.onclick = async ()=>{
  if(!stream) await startCamera();
  if(!detector) await ensureDetector();
  setStatus('Buscando...');
  const res = await detector.infer(video);
  if(res){ setStatus('Detectado'); setResult(res); } else { setStatus('Sin detección (intenta otra vez)'); setResult(null); }
};

btnManual.onclick = async ()=>{
  const type = selType.value;
  const value = selValue.value;
  const url = await resolveGuide({type, value});
  if(url){
    outUrl.innerHTML=`<a href="${url}" target="_blank" rel="noopener">${url}</a>`;
    btnOpenManual.disabled=false;
    btnOpenManual.onclick=()=>window.open(url,'_blank');
  } else {
    outUrl.textContent='No encontrada';
    btnOpenManual.disabled=true;
  }
};
