<?php
require_once __DIR__.'/env.php';

function openai_chat_vision_extract(array $images_dataurls, string $instruction){
  $apiKey = OPENAI_API_KEY;
  if (!$apiKey || $apiKey === 'REEMPLAZAR_OPENAI_API_KEY'){
    http_response_code(500);
    echo json_encode(['ok'=>false,'msg'=>'Falta configurar OPENAI_API_KEY']); exit;
  }
  $model = OPENAI_VISION_MODEL;

  $content = [['type'=>'text','text'=>$instruction]];
  foreach ($images_dataurls as $d) {
    $content[] = ['type'=>'image_url','image_url'=>['url'=>$d]];
  }

  $payload = [
    'model' => $model,
    'response_format' => ['type'=>'json_object'],
    'messages' => [
      ['role'=>'system','content'=>'Eres un experto en numismática colombiana. Devuelve SIEMPRE JSON válido con las claves solicitadas. Nunca texto adicional.'],
      ['role'=>'user','content'=>$content],
    ],
    'temperature' => 0.2,
    'max_tokens' => 300
  ];

  $doRequest = function() use ($payload, $apiKey){
    $ch = curl_init('https://api.openai.com/v1/chat/completions');
    curl_setopt_array($ch, [
      CURLOPT_POST => true,
      CURLOPT_RETURNTRANSFER => true,
      CURLOPT_HTTPHEADER => [
        'Authorization: Bearer '.$apiKey,
        'Content-Type: application/json'
      ],
      CURLOPT_POSTFIELDS => json_encode($payload),
      CURLOPT_TIMEOUT => 60,
      CURLOPT_HEADER => true
    ]);
    $res = curl_exec($ch);
    if ($res === false) {
      $err = curl_error($ch);
      curl_close($ch);
      return [0, [], json_encode(['error'=>['message'=>"OpenAI error: $err"]])];
    }
    $headerSize = curl_getinfo($ch, CURLINFO_HEADER_SIZE);
    $http = curl_getinfo($ch, CURLINFO_HTTP_CODE);
    $rawHeaders = substr($res, 0, $headerSize);
    $body = substr($res, $headerSize);
    curl_close($ch);

    $headers = [];
    foreach (explode("\r\n", $rawHeaders) as $line) {
      if (strpos($line, ':') !== false) {
        [$k,$v] = explode(':', $line, 2);
        $headers[strtolower(trim($k))] = trim($v);
      }
    }
    return [$http, $headers, $body];
  };

  [$http, $headers, $body] = $doRequest();
  $j = json_decode($body, true);

  if ($http === 429) {
    $code = $j['error']['code'] ?? '';
    if ($code === 'insufficient_quota') {
      return ['ok'=>false, 'http'=>429, 'code'=>$code, 'msg'=>'Cupo/crédito agotado en OpenAI.', 'detail'=>$j];
    }
    $retryAfter = (int)($headers['retry-after'] ?? 0);
    if ($retryAfter > 0) { @sleep(min($retryAfter, 3)); } else { @usleep(500000); }
    [$http2, $headers2, $body2] = $doRequest();
    $j2 = json_decode($body2, true);
    if ($http2 === 200) {
      $content = $j2['choices'][0]['message']['content'] ?? '';
      $data = json_decode($content, true);
      if (!$data) return ['ok'=>false,'msg'=>'OpenAI no devolvió JSON parseable','raw'=>$content];
      return ['ok'=>true,'data'=>$data,'raw'=>$content];
    }
    $code2 = $j2['error']['code'] ?? '';
    $msg = ($code2==='insufficient_quota') ? 'Cupo/crédito agotado en OpenAI.' : 'Límite de solicitudes alcanzado.';
    return ['ok'=>false,'http'=>$http2, 'code'=>$code2, 'msg'=>$msg, 'detail'=>$j2];
  }

  if ($http >= 400) {
    $code = $j['error']['code'] ?? '';
    $msg = ($code==='insufficient_quota') ? 'Cupo/crédito agotado en OpenAI.' : ($j['error']['message'] ?? 'Error OpenAI');
    return ['ok'=>false,'http'=>$http, 'code'=>$code, 'msg'=>$msg, 'detail'=>$j];
  }

  $content = $j['choices'][0]['message']['content'] ?? '';
  $data = json_decode($content, true);
  if (!$data) {
    return ['ok'=>false,'msg'=>'OpenAI no devolvió JSON parseable','raw'=>$content];
  }
  return ['ok'=>true,'data'=>$data,'raw'=>$content];
}
