const video=document.getElementById('video'), canvas=document.getElementById('frame'), ctx=canvas.getContext('2d');
const btnStart=document.getElementById('btn-start'), btnAI=document.getElementById('btn-ai'), btnUpload=document.getElementById('btn-upload'), file=document.getElementById('file');
const statusBadge=document.getElementById('status-badge');
const outParsed=document.getElementById('out-parsed'), outConf=document.getElementById('out-conf'), outUrl=document.getElementById('out-url'), outCands=document.getElementById('out-cands');
const selType=document.getElementById('sel-type'), selValue=document.getElementById('sel-value'), inpFamily=document.getElementById('inp-family'), inpYear=document.getElementById('inp-year'), inpVariant=document.getElementById('inp-variant');
const btnManual=document.getElementById('btn-manual'), btnOpenManual=document.getElementById('btn-open-manual');

const overlay=document.getElementById('overlay'), loaderText=document.getElementById('loader-text'), loaderStep=document.getElementById('loader-step'), loaderSr=document.getElementById('loader-sr');

let stream=null;

function setStatus(t){ statusBadge.textContent=t; }
function setDisabled(dis){ document.querySelectorAll('button,select,input[type=file],input[type=text]').forEach(el=>{ if(el.id!=='btn-start' || dis) el.disabled = dis; }); }
function showLoader(text='Procesando…', step=''){ overlay.classList.add('show'); overlay.setAttribute('aria-hidden','false'); loaderText.textContent=text; loaderStep.textContent=step||''; loaderSr.textContent=text+' '+step; setDisabled(true); document.body.setAttribute('aria-busy','true'); setStatus('Trabajando…'); }
function updateLoader(step=''){ loaderStep.textContent=step; loaderSr.textContent=loaderText.textContent+' '+step; }
function hideLoader(){ overlay.classList.remove('show'); overlay.setAttribute('aria-hidden','true'); setDisabled(false); document.body.removeAttribute('aria-busy'); setStatus('Listo'); }

async function startCamera(){ try{ stream=await navigator.mediaDevices.getUserMedia({video:{facingMode:'environment'},audio:false}); video.srcObject=stream; setStatus('Cámara encendida'); }catch(e){ setStatus('Error cámara: '+e.message); } }
function grabDataUrl(){ const w=video.videoWidth,h=video.videoHeight; if(!w||!h) return null; canvas.width=w; canvas.height=h; ctx.drawImage(video,0,0,w,h); return canvas.toDataURL('image/jpeg',0.92); }

async function aiIdentifyByDataUrl(dataUrl){
  showLoader('Analizando con IA…','Subiendo imagen'); 
  const r = await fetch('../api/ai_identify.php',{ method:'POST', headers:{'Content-Type':'application/json'}, body: JSON.stringify({ image_data: dataUrl }) });
  updateLoader('Identificando pieza…');
  const j = await r.json(); 
  return j;
}
async function aiIdentifyByFile(fileObj){
  showLoader('Analizando con IA…','Subiendo archivo'); 
  const fd = new FormData(); fd.append('file', fileObj);
  const r = await fetch('../api/ai_identify.php',{ method:'POST', body: fd });
  updateLoader('Identificando pieza…');
  const j = await r.json(); 
  return j;
}
async function resolveGuide(payload){
  updateLoader('Consultando guía…');
  const r = await fetch('../api/resolve.php',{ method:'POST', headers:{'Content-Type':'application/json'}, body: JSON.stringify(payload) });
  const j = await r.json(); 
  return j?.url||null;
}
function showAI(ai){
  if(!ai){ outParsed.textContent='—'; outConf.textContent='—'; outCands.textContent='—'; return; }
  const {type,value,family,year,variant,confidence,candidates} = ai;
  outParsed.textContent = `${type||'?'} ${value||'?'} ${family||''} ${year||''} ${variant||''}`.trim();
  outConf.textContent = typeof confidence==='number' ? (confidence*100).toFixed(1)+'%' : '—';
  if(Array.isArray(candidates) && candidates.length){
    outCands.textContent = candidates.map(c=>`${c.type||'?'} ${c.value||'?'} ${c.family||''} ${c.year||''} ${c.variant||''} (${Math.round((c.confidence||0)*100)}%)`).join(' | ');
  } else outCands.textContent='—';

  if(type) selType.value = type;
  if(value) selValue.value = String(value);
  if(family) inpFamily.value = family;
  if(year) inpYear.value = String(year);
  if(variant) inpVariant.value = variant;
}

btnStart.onclick=async()=> startCamera();

btnAI.onclick=async()=>{
  try{
    if(!stream) await startCamera();
    const d = grabDataUrl();
    if(!d){ setStatus('No hay frame de cámara'); return; }
    const j = await aiIdentifyByDataUrl(d);
    if(!j.ok){ setStatus('IA: '+(j.msg||'error')); hideLoader(); return; }
    showAI(j.ai);
    const url = await resolveGuide({ type:j.ai.type, value:j.ai.value, family:j.ai.family||'', year:j.ai.year||null, variant:j.ai.variant||'' });
    if(url){ outUrl.innerHTML = `<a class="link" href="${url}" target="_blank" rel="noopener">${url}</a>`; setStatus('Listo'); }
    else{ outUrl.textContent = 'No encontrada (ajusta family/año/variante)'; setStatus('Revisa campos'); }
  }catch(err){ setStatus('Error: '+err.message); }
  finally{ hideLoader(); }
};

btnUpload.onclick=()=> file.click();
file.onchange=async(e)=>{
  try{
    const f = e.target.files[0]; if(!f) return;
    const j = await aiIdentifyByFile(f);
    if(!j.ok){ setStatus('IA: '+(j.msg||'error')); hideLoader(); return; }
    showAI(j.ai);
    const url = await resolveGuide({ type:j.ai.type, value:j.ai.value, family:j.ai.family||'', year:j.ai.year||null, variant:j.ai.variant||'' });
    if(url){ outUrl.innerHTML = `<a class="link" href="${url}" target="_blank" rel="noopener">${url}</a>`; setStatus('Listo'); }
    else{ outUrl.textContent = 'No encontrada (ajusta family/año/variante)'; setStatus('Revisa campos'); }
  }catch(err){ setStatus('Error: '+err.message); }
  finally{ hideLoader(); }
};

btnManual.onclick=async()=>{
  try{
    showLoader('Consultando guía…','Usando datos manuales');
    const type=selType.value, value=parseInt(selValue.value,10), family=inpFamily.value.trim(), year=(inpYear.value||'').trim(), variant=(inpVariant.value||'').trim();
    const url = await resolveGuide({type,value,family,year:year?parseInt(year,10):null,variant});
    if(url){ outUrl.innerHTML=`<a class="link" href="${url}" target="_blank" rel="noopener">${url}</a>`; btnOpenManual.disabled=false; setStatus('Listo'); }
    else{ outUrl.textContent='No encontrada'; btnOpenManual.disabled=true; setStatus('Sin coincidencias'); }
  }catch(err){ setStatus('Error: '+err.message); }
  finally{ hideLoader(); }
};
