<?php
declare(strict_types=1);
header('Content-Type: application/json; charset=utf-8');
require_once __DIR__.'/../config/openai.php';

$ct = $_SERVER['CONTENT_TYPE'] ?? '';
$data_urls = [];
if (stripos($ct,'application/json')!==false){
  $j = json_decode(file_get_contents('php://input'), true) ?: [];
  $d = $j['image_data'] ?? null;
  if ($d) $data_urls[] = $d;
} else {
  if (!empty($_FILES['file']['tmp_name'])){
    $bin = file_get_contents($_FILES['file']['tmp_name']);
    $mime = mime_content_type($_FILES['file']['tmp_name']) ?: 'image/png';
    $data_urls[] = 'data:'.$mime.';base64,'.base64_encode($bin);
  }
}

if (!$data_urls) { echo json_encode(['ok'=>false,'msg'=>'No image data']); exit; }

$instruction = <<<TXT
Analiza la(s) imagen(es) y devuelve SOLO un JSON con estas claves:
- type: "billete" o "moneda".
- value: valor numérico en pesos (por ejemplo 10, 2000).
- family: código B/M### si es visible (por ejemplo "B020"); si no está claro, null.
- year: año visible si aplica; si no, null.
- variant: texto corto si hay (p.ej., "reposicion", "R_pequena", "firmas", o una fecha resumida como "30_Sep"). Si no, null.
- confidence: número 0..1 de confianza global en la identificación.
- candidates: arreglo (máximo 3) con opciones alternativas {type,value,family,year,variant,confidence}.

Devuelve SIEMPRE JSON puro y válido; no incluyas comentarios ni texto adicional.
TXT;

$res = openai_chat_vision_extract($data_urls, $instruction);
if (!$res['ok']) { echo json_encode($res); exit; }
echo json_encode(['ok'=>true,'ai'=>$res['data']]);
