<?php require_once __DIR__.'/../config/env.php'; ?><!doctype html>
<html lang="es">
<head>
  <meta charset="utf-8">
  <meta name="viewport" content="width=device-width,initial-scale=1">
  <title>Identificador CO — v4 (GPT Assistant Bridge)</title>
  <link rel="stylesheet" href="css/styles.css">
  <script async src="https://docs.opencv.org/4.x/opencv.js" onload="window.__cvReady=true;" onerror="window.__cvReady=false;"></script>
</head>
<body>
<header><h1>Identificador de Monedas y Billetes — v4</h1></header>
<div class="container">
  <div class="card">
    <div class="row">
      <div class="col">
        <div style="display:flex;justify-content:space-between;align-items:center;margin-bottom:8px;">
          <span class="badge" id="status-badge">Listo</span>
          <div class="small" style="display:flex;gap:12px;align-items:center;">
            <label><input type="checkbox" id="toggle-mock"> IA en navegador (TFJS)</label>
            <label><input type="checkbox" id="toggle-fine" checked> Verificación fina</label>
          </div>
        </div>
        <video id="video" autoplay playsinline muted></video>
        <canvas id="frame" style="display:none;"></canvas>
        <div style="display:flex;gap:8px;margin-top:10px;flex-wrap:wrap">
          <button class="btn btn-tonal" id="btn-start">Encender cámara</button>
          <button class="btn btn-tonal" id="btn-scan">Escanear</button>
          <button class="btn btn-tonal" id="btn-capture">Capturar & descargar foto</button>
          <button class="btn btn-primary" id="btn-open" disabled>Ver guía (auto)</button>
        </div>
        <p class="small" style="margin-top:8px;">Tip: Si la detección no es clara, usa el Asistente (abajo), sube la foto y él llamará la API para abrir la guía exacta.</p>
      </div>
      <div class="col">
        <div class="card" style="margin:0">
          <h3 style="margin-top:0;">Resultado</h3>
          <div class="kv">
            <div><strong>Label:</strong></div><div id="out-label">—</div>
            <div><strong>Confianza:</strong></div><div id="out-conf">—</div>
            <div><strong>Tipo/Valor:</strong></div><div id="out-parsed">—</div>
            <div><strong>URL guía:</strong></div><div id="out-url">—</div>
            <div><strong>Nitidez:</strong></div><div id="out-sharp">—</div>
            <div><strong>ROIs:</strong></div><div id="out-rois">—</div>
          </div>
          <hr>
          <h4>Prueba manual</h4>
          <div class="row">
            <div class="col">
              <label>Tipo</label>
              <select id="sel-type">
                <option value="billete">Billete</option>
                <option value="moneda">Moneda</option>
              </select>
            </div>
            <div class="col">
              <label>Valor</label>
              <select id="sel-value">
                <option>10</option><option>2</option><option>2000</option><option>50</option>
                <option>100</option><option>200</option><option>500</option><option>1000</option>
              </select>
            </div>
          </div>
          <div class="row" style="margin-top:8px;">
            <div class="col"><label>Año (opcional)</label><input id="inp-year" placeholder="1970, 2004, etc."></div>
            <div class="col"><label>Variante (opcional)</label><input id="inp-variant" placeholder="reposicion_R_pequena"></div>
          </div>
          <div class="row" style="margin-top:8px;">
            <div class="col"><label>Family (opcional)</label><input id="inp-family" placeholder="B020, B650, ..."></div>
          </div>
          <div style="margin-top:8px;display:flex;gap:8px;flex-wrap:wrap">
            <button class="btn btn-tonal" id="btn-manual">Resolver guía (manual)</button>
            <button class="btn btn-primary" id="btn-open-manual" disabled>Abrir guía (manual)</button>
          </div>
        </div>
      </div>
    </div>
  </div>

  <div class="card">
    <h3>Asistente virtual (ChatGPT)</h3>
    <p>Si prefieres que el asistente identifique por ti, capturá la foto y abrí el GPT personalizado. Él analiza la imagen, extrae <em>type, value, family, year, variant</em> y llama nuestra API para abrir la ficha correcta.</p>
    <div style="display:flex;gap:8px;flex-wrap:wrap">
      <a class="btn btn-primary" target="_blank" rel="noopener" href="<?php echo CHATGPT_GPT_URL; ?>">Abrir Asistente</a>
      <a class="btn btn-tonal" href="#" id="btn-help">¿Cómo usarlo?</a>
    </div>
    <div id="assistant-help" style="display:none;margin-top:8px" class="small">
      1) Haz clic en “Capturar & descargar foto”. 2) Abre el Asistente. 3) Sube la foto. 4) El Asistente te devolverá el link de la guía.
    </div>
  </div>

  <div class="small" style="opacity:.7;text-align:center;padding:16px 0 28px;">&copy; <?php echo date('Y'); ?> Identificador CO</div>
</div>
<script>const API_BASE='../api';</script>
<script type="module" src="js/app.js"></script>
</body></html>
